using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Linq;
using System.Linq.Expressions;

namespace PI.ZB.N1200.ELearning.WinForms.CompetencePart
{
    public partial class UCCompetencePartList : PI.FM.N000.Base.WinForms.Controls.UCBOList<CompetencePartView, UCCompetencePartDetails, BL.BO.CompetencePart.Search>
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        public UCCompetencePartList()
        {
            InitializeComponent();
        }

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        protected override void InitAll()
        {
            base.InitAll();

            CompetencePartView.ParrentBL = BLZSBELearning;

            DataManager.SaveMode = Gemini.Core.WinForms.Controls.GDataManagerSaveMode.SelectedObject;
            DataManager.AllowedActions = Gemini.Core.WinForms.Controls.Type.ControlActionType.Save | Gemini.Core.WinForms.Controls.Type.ControlActionType.Refresh | Gemini.Core.WinForms.Controls.Type.ControlActionType.RefreshCurrent | Gemini.Core.WinForms.Controls.Type.ControlActionType.New | Gemini.Core.WinForms.Controls.Type.ControlActionType.Delete;

            if (Param.ShowMode == Gemini.Core.WinForms.Interface.ShowMode.IntegratedWindow)
            {
                DataManager.AllowedActions = Gemini.Core.WinForms.Controls.Type.ControlActionType.Refresh;
            }

            DataManager.InitColumns(new string[] { "ID", "Name","Competence","IsValid","IsActive"});//Przetumaczone
            DataManager.ColumnCaptions = new string[] { Gemini.Dictionary.Text.Grid.ID.Value, Gemini.Dictionary.Text.Grid.Name.Value, BL.Dictionary.Text.Grid.Competence.Value, BL.Dictionary.Text.Grid.IsValid.Value, Gemini.Dictionary.Text.Grid.Enabled.Value };        
        }

        protected override void OnSave(Gemini.Core.WinForms.Controls.GDataManagerArgs<CompetencePartView> Args)
        {
            if (Args.Object != null)
            {
                DetailsView.Save();
                DataManager.RefreshCurrent();
            }
        }

        protected override CompetencePartView DoRestoreCurrent(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
        {
            return new CompetencePartView(BLZSBELearning.CompetencePart.View.Restore(BO));
        }

        protected override IList<CompetencePartView> OnLoadData(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            List<CompetencePartView> _listCompetencePartView = new List<CompetencePartView>();

            DataManager.TotalCount = BLZSBELearning.CompetencePart.Count();

            List<BL.BO.View.CompetencePart> _listCompetencePart  =  BLZSBELearning.CompetencePart.View.Restore();

            foreach(BL.BO.View.CompetencePart _loopCompetencePart in _listCompetencePart)
            {
                _listCompetencePartView.Add(new CompetencePartView(_loopCompetencePart));
            }

            return _listCompetencePartView;
        }

        protected override CompetencePartView OnCreate(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            FNewCompetencePart _dialogNew = Gemini.Core.WinForms.Base.Form.Create<FNewCompetencePart>(Plugin, Environment);

            _dialogNew.Initialize(Plugin, Environment);
            
            if (_dialogNew.ShowDialog() == DialogResult.OK)
            {
                if (_dialogNew.NewCompetencePart != null)
                {
                    return new CompetencePartView(BLZSBELearning.CompetencePart.View.Restore(_dialogNew.NewCompetencePart));
                }
            }
            return null;
        }

        protected override void OnRowClick()
        {
            Environment.WindowsHandler.Show(this.Plugin.Name, new Gemini.Core.WinForms.Base.AccessDescription(BL.Dictionary.Objects.UI.CompetencePartEdit), new PI.FM.N000.Base.WinForms.Classes.Param(DataManager.Current.Source));
        }

        public override void DialogResultOK()
        {
                Param.Object = DataManager.Current.Source;
                Param.ObjectTitle = DataManager.Current.Name;
                Param.ObjectID = DataManager.Current.ID;
                Param.IsObjectValid = true ;
                Param.ClientID = BLZSBELearning.ClientID;
                Param.ObjectList = DataManager.GetSelectedObjects().Select(x => (FM.N000.Base.BL.BO.Base)x.Source).ToList();
        }
    }
}
